/**********************************************************************************************
	Container MacroScript File

	This file contains scripted commands related to containers
	
	Author:   Nicolas Lonard

	MODIFY THIS AT YOUR OWN RISK
***********************************************************************************************/

macroScript OpenContainerExplorer 
category:~OPENCONTAINEREXPLORER_CATEGORY~ 
internalCategory:"Containers" 
ButtonText:~OPENCONTAINEREXPLORER_BUTTONTEXT~
tooltip:~OPENCONTAINEREXPLORER_TOOLTIP~ 
-- No icon yet
(
	on isEnabled return true
	on isChecked return false
	on isVisible return true
	on execute do
	(
		-- If the container explorer has not been loaded yet, do it now.
		-- We rely on the explorer name "Container Explorer" as defined in the 
		-- InstanceName field of the "DefaultContainerExplorer.ini" file.
		if not SceneExplorerManager.ExplorerExists ~CONTAINEREXPLORER_CAPTION~ then
		(
			local cfgpath = pathConfig.GetDir #plugcfg
			cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
			local cfgfile = pathConfig.appendPath cfgpath "DefaultContainerExplorer.ini"
			SceneExplorerManager.LoadExplorerConfiguration cfgfile
		)
		SceneExplorerManager.OpenExplorer ~CONTAINEREXPLORER_TITLE~
	)
)

